/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import jade.util.Logger;

public class RWLock {
    private int readersCnt = 0;
    private Thread currentWriter = null;
    private int writeLockDepth = 0;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    public synchronized void writeLock() {
        Thread me = Thread.currentThread();
        while (this.currentWriter != null && this.currentWriter != me || this.readersCnt > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                if (!this.logger.isLoggable(9)) continue;
                this.logger.log(9, "Unexpected interruption. " + ie.getMessage());
            }
        }
        ++this.writeLockDepth;
        if (this.writeLockDepth == 1) {
            this.currentWriter = me;
            this.onWriteStart();
        }
    }

    public synchronized void writeUnlock() {
        if (Thread.currentThread() == this.currentWriter) {
            --this.writeLockDepth;
            if (this.writeLockDepth == 0) {
                this.currentWriter = null;
                this.notifyAll();
                this.onWriteEnd();
            }
        }
    }

    public synchronized void readLock() {
        while (this.currentWriter != null) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                if (!this.logger.isLoggable(9)) continue;
                this.logger.log(9, "Unexpected interruption. " + ie.getMessage());
            }
        }
        ++this.readersCnt;
    }

    public synchronized void readUnlock() {
        --this.readersCnt;
        if (this.readersCnt == 0) {
            this.notifyAll();
        }
    }

    protected void onWriteStart() {
    }

    protected void onWriteEnd() {
    }
}

